<?php
/**
 * Default Page
 *
 * @since    1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>	
<div class="tipi-block tipi-default">
	<h3><?php esc_html_e( 'Default Values', 'lets-review' ); ?></h3>
	<p><?php esc_html_e( 'Set the default settings you want reviews to have when adding a new review.', 'lets-review' ); ?></p>
	<br>
	<form action="options.php" method="post">
		<?php settings_fields( 'lets-review-settings-gd' ); ?>
		<?php do_settings_sections( 'lets-review-defaults' ); ?>
		<?php submit_button( esc_html__( 'Save Changes', 'lets-review' ) ); ?>
		<?php wp_nonce_field( 'lets-review-defaults', 'lets-review-defaults-nonce' ); ?>
	</form>
</div>